/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.javaone.anagram;

import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import org.javaone.anagram.ui.Anagrams;
import org.openide.windows.Mode;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public final class NewGame implements ActionListener {

    public void actionPerformed(ActionEvent e) {
       Mode editorMode = WindowManager.getDefault ().findMode ("editor");
         assert editorMode != null && WindowManager.getDefault ().isEditorMode (editorMode);
         TopComponent tc = new GameTopComponent (new Anagrams ());
         tc.open();
         tc.requestActive();
     }

     private class GameTopComponent extends TopComponent {
         private Anagrams game;
         public GameTopComponent (Anagrams game) {
             initComponents ();
             this.game = game;
             add (game.getContentPane (), BorderLayout.CENTER);
         }
         private void initComponents() {
             this.setLayout (new BorderLayout ());
         }

         @Override
         public String getDisplayName() {
             return "Anagram Game";
         }

         @Override
         public int getPersistenceType () {
             return PERSISTENCE_NEVER;
         }

         @Override
         protected String preferredID () {
             return Integer.toString (System.identityHashCode (game));
         }

     }

}
